--------------------------------------------------------------------
--            SymCACP Script Module 1       
-- Symmetrical CA Control Panel   symCACPscript-1
-- file for family tree relations 
-- read GRDCOM file 
-- 
-- modified for script2
--------------------------------------------------------------------
--  P. Rendell   11/08/2020
--------------------------------------------------------------------
-- O/P
-- RULE,GEO, WD, SEED,  STRIPDIR, START_X, START_Y, GEN, DIST, RUNLENG

--==============================================================================
------------------------------------------------------------

local scriptType = "script2-FT-Rel"
local m={}			-- class table
local comProcs			-- common Procedures
local logFile
local outFile
local g = golly()
local scriptFileData
local logDiverted = false
local gr = require("buildUni") 
--  "r" = rule, "s" = seed, "d" = decimal "t" = text, "g" = geo
-- "R" = required
m.colonList = {['PEOPLE'] = {"p","R"}}
m.equalList = {['LOGFILE'] = {'t',""}, ['GEDFILE'] = {'t',"R"},  ['RESULTS'] = {'t',""}, 
               ['SURNAME'] = {"t","R"}, ['FORENAME'] = {"t","R"},  ['BIRTH_YR'] = {'t',"R"} }
------------------------------------------------------------------------------------------------
------------------------------------------------------------------------------------------------

------------------------------------------------------------------------------------------------
--local FORENAME = 'forename'
local ID = 'id'

local GIVENNAME = 'GIVN'
local SURNAME = 'SURN'
local CHILD = 'CHIL'
local CHILDFAM = 'FAMC'
local ADULTFAM = 'FAMS'
local WIFE = 'WIFE'
local HUSBAND = 'HUSB'
local DEATH = 'DEAT'
local BIRTH = 'BIRT'
local DATE  = 'DATE'
local BIRTHDATE = 'BIRTDATE'
local DEATHDATE = 'DEATDATE'
local GENDER = 'SEX'
------------------------------------------------------------------------------------------------
-- utilities
------------------------------------------------------------------------------------------------
function trim(str)
   local s = (str or '')
   return s:match "^%s*(.-)%s*$"
end
--------------------------------------------------------------------------------
function makeList(str)
   local list = {}
   for word in string.gmatch(str, "[^%s,]+") do
      list[#list + 1] = word
   end
   return list
end
------------------------------------------------------------------------------------------------
function tableLen(tab)
   local l = 0
   for i, v in pairs(tab) do
      l = l +1
   end
   return l
end
------------------------------------------------------------------------------------------------
function stringArray(a1)
   local str = ''
   local sep = ''
   for _, v in pairs(a1) do
       str = str..sep..v
       sep = ','
   end
   return str
end
------------------------------------------------------------------------------------------------
function joinArrays(a1,a2)
   for _, v in pairs(a2) do
       table.insert(a1, v)
   end
   return a1
end
------------------------------------------------------------------------------------------------
function diffText(txtGvn, txtPer, outFile)
   local tGvn = trim(txtGvn):upper()
   local tPer = trim(txtPer):upper()
   local res = 1.0
   if (tGvn == tPer) then
      res = 0.1
   elseif string.find(tPer,' ') then
      local gvnLst = makeList(tGvn)
      local partsFound = 0
      local partsOrder = 0
      local partsOrded = true
      for i, gvnWord in ipairs(gvnLst) do
         p0,p1 = string.find(tPer,gvnWord)
         if p0 then
            partsFound = partsFound +1
            if (p0 <= partsOrder) then
               partsOrded = false
            end
         end
      end
      res = 1 - 0.8 * partsFound/#gvnLst
   end
   if (res == 1) then
      p0,p1 = string.find(tPer,tGvn)
      if p0 then
         res = 0.2
      elseif (tonumber(tGvn) ~= nil) then
         local perLst = makeList(tPer)
         local thisDiff
         for i, perWord in ipairs(perLst) do
            if (tonumber(perWord) ~= nil) then
               if thisDiff then
                   thisDiff = math.min(thisDiff, math.abs(tonumber(perWord) - tonumber(tGvn)))
               else
                   thisDiff = math.abs(tonumber(perWord) - tonumber(tGvn))
               end
            end
         end
        if thisDiff then
           res =  (1-(tonumber(tGvn) - thisDiff) / tonumber(tGvn))
        end
      end
   end
   return res
end
------------------------------------------------------------------------------------------------
------------------------------------------------------------------------------------------------

local function newFT()
   local mm = {}
   mm.personLst = {}
   mm.familyLst = {}
   
   -----------------------------------------------
   function mm.newPerson(id)
      local mmm = {}
      mm.personLst[id]=mmm
      mmm.ID=id
      outFile:write("new person :"..id..':\n')
      -----------------------------------------------   
      function mmm.add(element, text)         
         if (element == CHILDFAM) or (element == ADULTFAM) then
            mm.getFamily(text).addLst(element, mmm.ID)
            mmm[element] = mm.getFamily(text)
           outFile:write("Add Family  "..text..' Pers '..mmm.ID..'\n')
         else
            mmm[element] = text
         end
      end   
      -----------------------------------------------   
      function mmm.get(element)
         return mmm[element] or '.'   
      end   
      -----------------------------------------------   
      function mmm.addFam(element, text)
         if (not mmm[element]) then
            mmm[element] = {}
            outFile:write('\naddFam '..element..' '..text..'\n')
         end
         mm.getFamily(text).addLst(element, mmm.ID)
         mmm[element][#mmm[element]+1] = mm.getFamily(text)
      end   
      -----------------------------------------------   
      function mmm.getFam(element)
         return (mmm[element] or {})
      end   
      -----------------------------------------------   
      function mmm.getParents()
         lst = {}
         for i, famC in pairs( mmm.getFam(CHILDFAM)) do
            lst = joinArrays(lst, famC.getLst(ADULTFAM))
         end
         return lst
      end   
      -----------------------------------------------   
      function mmm.getPartners()
         lst = {}
         for i, famA in pairs( mmm.getFam(ADULTFAM)) do
            lst = joinArrays(lst, famA.getLst(ADULTFAM))
         end
         return lst
      end   
      -----------------------------------------------   
      function mmm.getChildren()
         lst = {}
         for i, famA in pairs( mmm.getFam(ADULTFAM)) do
            lst = joinArrays(lst, famA.getLst(CHILDFAM))
         end
         return lst
      end   
      -----------------------------------------------   
      function mmm.getSiblings()
         lst = {}
         for i, famC in pairs( mmm.getFam(CHILDFAM)) do
            lst = joinArrays(lst, famC.getLst(CHILDFAM))
         end
         local sLst = {}
         for i, per in ipairs(lst) do
            if (per ~= mmm) then
               sLst[#sLst+1] = per
            end
         end
         return sLst
      end   
      -----------------------------------------------
      function mmm.nameAndDates()
         return  mmm.get(GIVENNAME)..' '..mmm.get(SURNAME)..' '..mmm.get(BIRTHDATE)..'-'..mmm.get(DEATHDATE)
      end
      -----------------------------------------------   
      return mmm
   end
   -----------------------------------------------
   function mm.newFamily(id)
      local mmm = {}
      mm.familyLst[id] = mmm
      mmm.ID = id
      outFile:write("New Family  "..mmm.ID..'\n')
      -----------------------------------------------   
      function mmm.addLst(element, text)
         if (not mmm[element]) then
            mmm[element] = {}
         end
         if (element == CHILDFAM) or (element == ADULTFAM) then
            local p = mm.findPerson(text)
            if (p) then 
               mmm[element][#mmm[element]+1] = p
            else
               outFile:write("*** Family addLst "..element..'.'..text..' not found\n')
            end
         else
            mmm[element][#mmm[element]+1] = text
         end
         outFile:write("Family addLst "..mmm.ID..'.'..element..'='..text..'('..#mmm[element]..')\n')
      end   
      -----------------------------------------------   
      function mmm.getLst(element)
         return (mmm[element] or {})
      end   
      -----------------------------------------------   
      return mmm
   end
   -----------------------------------------------
   function mm.getFamily(id)
      outFile:write("getFamily "..id..'\n')
      return mm.familyLst[id] or mm.newFamily(id)
   end
   -----------------------------------------------
   function mm.findPerson(element)
      outFile:write("found person :"..element..':\n')
      outFile:write("found person "..element..' '..(mm.personLst[element].ID or '.')..'\n')
      return mm.personLst[element]
      
   end
   -----------------------------------------------
   function mm.findPeople(element, txt, maxMatchLen, maxMatchValP, outFile)
      local maxMatchVal = maxMatchValP
      local matchLst = {}
      local txt2, matchVal
      local ps = 0
      local nams = 0
      local score = 1
      for perID, per in pairs(mm.personLst) do
         ps = ps + 1
         txt2 = per.get(element)
         score = diffText(txt, txt2, outFile)
         if score < 0.5 then
            matchLst[#matchLst + 1]={per, score}
         end
      end
      outFile:write(element..' '..txt..' list length '..#matchLst..' people '..ps..' names '..nams..'\n')
      for i, perData in ipairs(matchLst) do
         outFile:write(element..' '..txt..' '..i..' '..(perData[1].get(GIVENNAME) or '.')..'\n')
      end
      
      return matchLst
   end
   -----------------------------------------------
   return mm
end

--==============================================================================

function m.init(lf, cp)
   scriptFileData = {}
   comProcs = cp
   logFile = lf
   g.show("hi ft")
end

------------------------------------------------------------------------------------------------
function m.buildParmVal(cmd, value, segNo)
   if (scriptFileData[cmd]) then
      m.report.collect("Previous value overwriten "..cmd.." = "..value.."\n",true, segNo)
   end
   scriptFileData[cmd] = value
   g.show("hi ft bp")
end

------------------------------------------------------------------------------------------------
function m.buildParmLst(cmd, parms, segNo)
   if (not scriptFileData[cmd]) then
      scriptFileData[cmd] = {}
   end
   for i, parm in pairs(parms) do
      table.insert(scriptFileData[cmd],parm)
   end
end

------------------------------------------------------------------------------------------------
function m.validateScript()
   return true
end
--==============================================================================
--==============================================================================

------------------------------------------------------------
------------------------------------------------------------
------------------------------------------------------------

local function divertLog()
   res = true
   local log = io.open ( scriptFileData.LOGFILE , "w")
   if log then
      logFile:write('Diverting to logfile '..scriptFileData.LOGFILE..'\n')
      logDiverted = true
      logFile:close()
      logFile = log
      log = nil
      comProcs.newLog(logFile)
   else
      logFile:write('Failed to divert to logfile '..scriptFileData.LOGFILE..'\n')
      res = false
   end
   return res
end
------------------------------------------------------------

local function reDivertLog()
   if logDiverted then
      logFile:close()
      logFile = comProcs.oldLog()
      logFile:write('Continue after log diversion\n')
   end
   logDiverted = false
end
------------------------------------------------------------

local function parseGedLine(ft, lineP, outFile, state)
   local useful = {[GIVENNAME] = {1},[SURNAME] = {1},[BIRTH] = {1},[DEATH] = {1},[DATE] = {1}, [CHILD] = {1},
                    [CHILDFAM] = {1},[ADULTFAM] = {1},[WIFE] = {1},[HUSBAND] = {1},[GENDER] = {1}}
   local link = {['@I'] = {1}} --,['@F'] = {1}}
   local str0 = 1
   local line = trim(lineP)
   local str1 = string.len(line)
   local newState = state			-- state[1] = '':start, 'I':idividual, 'F':family
                                                -- state[2] = level
                                                -- state[3] = Date Type
                                                -- state[4] = p
                                                -- state[5] = f
   local p = state[4]
   local f = state[5]
--   outFile:write("["..lineP.."]\n")
   local num0 = str0
   while (string.sub(line,str0,str0) ~= ' ') and (str0 < str1) do
      str0 = str0 +1
   end
   local num1 = str0
   while string.sub(line,str0,str0) == ' ' do
      str0 = str0 +1
   end
   local key0 = str0
   while (string.sub(line,str0,str0) ~= ' ') and (str0 < str1) do
      str0 = str0 +1
   end
   local key1 = str0
   if (string.sub(line,key1,key1) == ' ') then
      key1 = key1 -1
   end
   while string.sub(line,str0,str0) == ' ' do
      str0 = str0 +1
   end
   local cmd = string.sub(line,key0,key1)
   local ok = true
   if (newState[2] >= string.sub(line,num0,num1-1)) then
      newState = {'',''}
      ok = false
      if (p) then
         outFile:write('END Block '..state[1]..'('..line..') Born '..p.get(BIRTHDATE)..'-'..p.get(DEATHDATE)..'\n')
      else
         outFile:write('END Block '..state[1]..'('..line..')\n')
      end
      p = nil
      f = nil
   end
   if (newState[1] == '') then
      if link[string.sub(cmd,1,2)] then
         newState[1] = string.sub(line,key0,key1)
         newState[2] = string.sub(line,num0,num1-1)
         newState[3] = nil
         outFile:write('NEW Block '..newState[1]..'('..line..')\n')
         if (string.sub(cmd,2,2) == 'I') then
            p = ft.newPerson(string.sub(line,key0,key1))
         end
      end
   end

   if (useful[cmd]) then
      if p and ((cmd == BIRTH) or (cmd == DEATH)) then
         newState[3] = cmd
         outFile:write(newState[1]..':'..newState[3]..' E('..line..')\n')
      else
         if p and (cmd == DATE) then
            if (newState[3]) then
               p.add(newState[3]..DATE, string.sub(line,str0,str1))
               outFile:write(newState[3]..' '..newState[1]..' E('..line..')\n')
               newState[3] = nil
            end
            ok = false
         end
         if ok then
            if (p) then
               if (cmd == CHILDFAM) or (cmd == ADULTFAM) then
                  p.addFam(cmd, string.sub(line,str0,str1))
               else
                  p.add(cmd, string.sub(line,str0,str1))
               end
               outFile:write(newState[1]..':'..string.sub(line,num0,num1-1)..'.'..cmd..'+'..string.sub(line,str0,str1)..'\n')
            else
--               outFile:write(newState[1]..':'..string.sub(line,num0,num1-1)..'.'..cmd..'+'..string.sub(line,str0,str1)..'no person\n')
            end
         end
      end
   end
   newState[4] = p
   newState[5] = f
   return newState
end
------------------------------------------------------------

local function loadGEDCOM(outFile, ft)
   res = flase
   local gedFile = io.open ( scriptFileData.GEDFILE , "r")
   if gedFile then
      logFile:write('files open '..scriptFileData.GEDFILE..'\n')
      gedFile:write('files open '..scriptFileData.GEDFILE..'\n')

      local line = gedFile:read("*l")
      local state = {'','0'}
      while line do
         state = parseGedLine(ft, line, outFile, state)
         line = gedFile:read("*l")
      end

      gedFile:close()
      res = true
   else
      comProcs.note('Failed to open input file '..scriptFileData.GEDFILE)
      logFile:write('Failed to open input file '..scriptFileData.GEDFILE..'\n')
   end
   return res
end
------------------------------------------------------------

function findRelations(outFile, surname, forename, birth_yr, ft)
   outFile:write('\nfindRelations\n')
   local listSURN = ft.findPeople(SURNAME, (surname or ''), 0, 0, outFile)
   outFile:write('listSURN length '..#listSURN..'\n')
   local listFORE = {}
   for i, perData in ipairs(listSURN) do
      score = diffText(forename, (perData[1].get(GIVENNAME) or '.'), outFile)
      if score < 0.5 then
         listFORE[#listFORE + 1]={perData[1], perData[2], score}
      end
   end
   outFile:write('listFORE length '..#listFORE..'\n')
   for i, perData in ipairs(listFORE) do
      outFile:write(string.format("%.3f",perData[2])..'   '..(surname or '')..' '..(perData[1].get(GIVENNAME) or '.')..'\n')
   end
   local listBDate = {}
   for i, perData in ipairs(listFORE) do
      score = diffText(birth_yr, (perData[1].get(BIRTHDATE) or '.'), outFile)
      if score < 50.9 then
         listBDate[#listBDate + 1]={perData[1], perData[2], perData[3], score, perData[2] + perData[3] +score}
      end
   end
   table.sort(listBDate, function(a,b) return a[5] < b[5] end)
   outFile:write('listBDate length '..#listBDate..'\n')
   for i, perData in ipairs(listBDate) do
      outFile:write(string.format("%.3f",perData[2])..'   '..string.format("%.3f",perData[3])..'   '..string.format("%.3f",perData[4])..'   '..surname..' '..(perData[1].get(GIVENNAME) or '.')..' '..(perData[1].get(BIRTHDATE) or '.')..'\n')
   end

   if not (listBDate[1] and listBDate[1][1] and listBDate[1][1].get(CHILDFAM)) then
      outFile:write('no family '..(surname or '.')..' '..(forename or '.')..'\n')
   else
   
      local pers = listBDate[1][1]

      outFile:write('\nParents of '..pers.FAMS[1].ID..'.FAMS '..pers.nameAndDates()..'\n')
      for i, per in ipairs(pers.getParents()) do
         outFile:write((per.nameAndDates() or '.')..'\n')
      end

      outFile:write('\nPartners of '..pers.FAMS[1].ID..'.FAMS '..pers.nameAndDates()..'\n')
      for i, per in ipairs(pers.getPartners()) do
         outFile:write((per.nameAndDates() or '.')..'\n')
      end
            
      outFile:write('\nSiblings of '..pers.FAMS[1].ID..'.FAMS '..pers.nameAndDates()..'\n')
      for i, per in ipairs(pers.getSiblings()) do
         outFile:write((per.nameAndDates() or '.')..'\n')
      end

      outFile:write('\nChildren of '..pers.FAMS[1].ID..'.FAMS '..pers.nameAndDates()..'\n')
      for i, per in ipairs(pers.getChildren()) do
         outFile:write((per.nameAndDates() or '.')..'\n')
      end
   end
end

------------------------------------------------------------
local function splitName(nameText)		-- Joseph_Clayton:1896
   local res = {}
   local n
   res[1],n  = string.gsub(nameText:match "([^:]-)_*[^_:]*:[^_:]*%s*$" or '?','_',' ')
   res[2] = nameText:match "[^:]*_([^_:]-):[^_:]*%s*$" or '?'
   res[3] = nameText:match "[^:]*:([^_:]-)%s*$" or '?'
   return res
end

------------------------------------------------------------
function m.run(segmentNo)

   ---------------------  script data-----------------------
   --  SURNAME = , FORNAME = DENYS, BIRTH_YR = 
   -- RESULTS = file, GEDFILE = file

   ---------------------------------------------------------
   g.show("hi ft run")
   local startTime = os.clock()
   local ft = newFT()
   g.show('FT Relation Started')
   logFile:write('\nFT Relation Started\n')
   if scriptFileData then
      if scriptFileData.LOGFILE then
         logDiverted = divertLog(scriptFileData.LOGFILE)
      end
      comProcs.LogScript(segmentNo)
      outFile = io.open ( scriptFileData.RESULTS , "w")
      if outFile then

         if (loadGEDCOM(outFile, ft)) then
       
            findRelations(outFile, scriptFileData.SURNAME, scriptFileData.FORENAME, scriptFileData.BIRTH_YR, ft)
            outFile:write('\n')
            for ip = 1,#scriptFileData.PEOPLE do
               perText = scriptFileData.PEOPLE[ip]
               outFile:write(perText..'\n')
               local nameBits = splitName(perText)
               outFile:write(stringArray(nameBits)..'|\n')
               findRelations(outFile, nameBits[2], nameBits[1], nameBits[3], ft)

            end
            
         end
         
         outFile:close()

      else
         comProcs.note('Failed to open output file '..scriptFileData.RESULTS)
         logFile:write('Failed to open output file '..scriptFileData.RESULTS..'\n')
      end

      local elapsed = os.clock()-startTime
      local elHrs = math.floor(elapsed/3600)
      local elMins = math.floor((elapsed-elHrs*3600)/60)
      local elSecs = (elapsed-elHrs*3600-elMins*60)
      g.show(string.format("Finished Run Length in %2d Hrs %2d Mins %2.2f Secs\n", elHrs,elMins,elSecs  ))
      logFile:write(string.format("Finished Run Length in %2d Hrs %2d Mins %2.2f Secs\n", elHrs,elMins,elSecs  ))
      logFile:flush()
      if logDiverted then
         reDivertLog()
      end
   else
      comProcs.note('No Script file Loaded')
   end   
end

return m
------------------------------------------------------------
